'use strict';

easycredithub.widgets.module('easycreditloader', [gambio.source + '/libs/events'], function (data) {
	'use strict';

	if (window.NodeList && !NodeList.prototype.forEach) {
		NodeList.prototype.forEach = Array.prototype.forEach;
	}

	var currentScript = document.currentScript;

	// ########## VARIABLE INITIALIZATION ##########
	var $this = $(this),
	    defaults = {},
	    options = $.extend(true, {}, defaults, data),
	    module = {};

	module.init = function (done) {
		if (typeof easyCreditParameters !== 'undefined' && typeof window.rkPlugin === 'undefined') {
			var pluginSrc = 'https://ratenkauf.easycredit.de/ratenkauf/js/ratenrechner/v1/ratenrechner.js';
			var pluginScript = document.createElement('script');
			pluginScript.src = pluginSrc;
			pluginScript.onload = pluginLoaded;

			if (currentScript) {
				currentScript.parentNode.insertBefore(pluginScript, currentScript);
			} else {
				document.querySelector('script:last-of-type').parentNode.appendChild(pluginScript);
			}
		}
		done();
	};

	var pluginLoaded = function pluginLoaded() {
		var placeholderElement = document.querySelector('div.easycredit-rr-container');
		if (!placeholderElement) {
			return;
		}
		if (!easyCreditParameters) {
			return;
		}

		var styleSrc = 'https://ratenkauf.easycredit.de/ratenkauf/js/ratenrechner/v1/ratenrechner.css';
		var pluginStyle = document.createElement('link');
		pluginStyle.rel = 'stylesheet';
		pluginStyle.type = 'text/css';
		pluginStyle.href = styleSrc;
		if (currentScript) {
			currentScript.parentNode.insertBefore(pluginStyle, currentScript);
		} else {
			document.querySelector('script:last-of-type').parentNode.appendChild(pluginStyle);
		}
		placeholderElement.style.backgroundImage = 'url("https://static.easycredit.de/content/image/logo/ratenkauf_42_55.png")';

		rkPlugin.anzeige(placeholderElement.id, {
			webshopId: easyCreditParameters.shopId,
			finanzierungsbetrag: easyCreditParameters.finanzierungsbetrag,
			euro: easyCreditParameters.euro,
			textVariante: easyCreditParameters.textVariante,
			linkText: easyCreditParameters.linkText,
			fromText: easyCreditParameters.fromText,
			installmentTemplate: easyCreditParameters.installmentTemplate,
			widgetTemplate: easyCreditParameters.widgetTemplate
		});

		if (easyCreditParameters.hasVariants) {
			$(window).on(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE(), function () {
				var currentPriceText = $('form.product-info div.current-price-container').text();
				var extractedPrice = currentPriceText.replace(/[0-9,.]+ (EUR|€) pro .*/, '').replace(/.*?([0-9,.]+ (EUR|€)(?!.*(EUR|€).*)).*/, '$1').replace(/[^0-9]*/g, '');
				var currentPrice = parseInt(extractedPrice) / 100;
				console.log('price changed to ' + currentPrice);
				$(placeholderElement).empty();
				rkPlugin.anzeige(placeholderElement.id, {
					webshopId: easyCreditParameters.shopId,
					finanzierungsbetrag: currentPrice,
					euro: easyCreditParameters.euro,
					textVariante: easyCreditParameters.textVariante,
					linkText: easyCreditParameters.linkText,
					fromText: easyCreditParameters.fromText,
					installmentTemplate: easyCreditParameters.installmentTemplate,
					widgetTemplate: easyCreditParameters.widgetTemplate
				});
			});
		}
	};

	return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
